#include "timeutil.h"

#ifdef WIN32
	#include <sys/types.h>
	#include <sys/timeb.h>
#else
	#include <sys/time.h>
#endif // WIN32

double getTimeOfDay()
{
#ifdef WIN32
	struct _timeb tv;

	_ftime(&tv);
	return ((double)tv.time) + ((double)tv.millitm/1000.0);
#else
	struct timeval tv;

	gettimeofday(&tv, 0);

	return (((double)tv.tv_sec)+((double)tv.tv_usec/1000000.0));
#endif // WIN32
}
