#ifndef TESTSIMULATOR2D_H

#define TESTSIMULATOR2D_H

#include "simulator2d.h"
#include <vector>

class TestSimulator2D : public Simulator2D
{
public:
	TestSimulator2D();
	~TestSimulator2D();
	
	bool init(Simulation *pSim);
	bool simulate(int maxSeconds);
private:
	void clear();
	bool hasNaN(const std::vector<double> &v);
	bool hasNeg(const std::vector<double> &v);

	class SnapShot
	{
	public:
		SnapShot(const std::vector<double> &n, const std::vector<double> &p, const std::vector<double> &V,
		         double dt, int step)
		{
			m_n = n;
			m_p = p;
			m_V = V;
			m_dt = dt;
			m_step = step;
			m_stepMultiplier = 1;
		}

		const double *getN() const							{ return &(m_n[0]); }
		const double *getP() const							{ return &(m_p[0]); }
		const double *getV() const							{ return &(m_V[0]); }
		double getDt() const								{ return m_dt; }
		int getStep() const								{ return m_step; }
		int getStepMultiplier() const							{ return m_stepMultiplier; }
		void increaseStepMultiplier()							{ m_stepMultiplier *= 2; }
		void setStepMultiplier(int m) 							{ m_stepMultiplier = m; }
	private:
		std::vector<double> m_n, m_p, m_V;
		double m_dt;
		int m_step;
		int m_stepMultiplier;
	};

	Simulation *m_pSim;
	double m_dtStart;
	std::vector<SnapShot *> m_snapShots;
};

#endif // TESTSIMULATOR2D_H
