#ifndef SIMULATION2D_H

#define SIMULATION2D_H

#include <errut/errorbase.h>
#include <serut/serializationinterface.h>
#include "constants.h"

class SimulationState;

class Simulation2D : public errut::ErrorBase
{
public:
	Simulation2D()												{ }
	~Simulation2D()												{ } 

	virtual bool isInitialized() const = 0;
	virtual int getNumXPixels() const = 0;
	virtual int getNumYPixels() const = 0;
	virtual double getPixelWidth() const = 0;
	virtual double getPixelHeight() const = 0;

	virtual bool setState(const SimulationState &state, std::vector<std::string> &warnings);
	virtual bool storeState(SimulationState &state) const;

	virtual bool start(int steps, double dt, bool inverseMatrixSolver);
	virtual bool start(int seconds, double dt, int &steps, bool inverseMatrixSolver);
	virtual bool start(double &sigma);
	
	virtual void calculateXCurrent(double &leftAvg, double &rightAvg, double &overallAvg, double &center) const = 0;
	virtual void calculateYCurrent(double &bottomAvg, double &topAvg, double &overallAvg, double &center) const = 0;
};

#endif // SIMULATION2D_H

