#ifndef SIMULATION1D_H

#define SIMULATION1D_H

#include <errut/errorbase.h>
#include <serut/serializationinterface.h>
#include <vector>

class SimulationState;

class Simulation1D : public errut::ErrorBase
{
public:
	Simulation1D()												{ }
	~Simulation1D()												{ }

	virtual bool isInitialized() const = 0;

	//bool import(const Simulation1D &s);

	bool setState(const SimulationState &state, std::vector<std::string> &warnings);
	bool storeState(SimulationState &state) const;

	virtual int getNumXPixels() const = 0;
	virtual double getPixelWidth() const = 0;

	virtual bool start(int &steps, double dt, double stopCriterion = -1.0);
	virtual bool start(int seconds, double dt, int &steps, double stopCriterion = -1.0);
	virtual bool start(double &sigma);

	virtual void calculateXCurrent(double &leftAvg, double &rightAvg, double &overallAvg, double &center) const = 0;

};

#endif // SIMULATION1D_H

