#ifndef SIMIMPIMOGA_H

#define SIMIMPIMOGA_H

#include <mogal/mpigeneticalgorithm.h>
#include <string>

namespace shellp
{
	class IOSystem;
}

class ExtProgGenome;

class SimiMPIMOGA : public mogal::MPIGeneticAlgorithm
{
public:
	SimiMPIMOGA(const std::string &translateCmd, mogal::GAFactory *pFactory);
	~SimiMPIMOGA();

	void printSolutions(bool final = true) const;
private:
	void onCurrentBest(const std::list<mogal::Genome *> &bestGenomes) const;
	void feedbackStatus(const std::string &str) const;
	void writeLog(int level, const char *fmt, ...);
	static std::string getFitnessString(ExtProgGenome *pGenome);
	bool onAlgorithmLoop(mogal::GAFactory &factory, bool generationInfoChanged);

	std::string m_translateCmd;
	bool m_gotTranslateCmd;
	mutable bool m_translateError;

	shellp::IOSystem *m_pIOSys;
	mogal::GAFactory *m_pFactory;
};

#endif // SIMIMPIMOGA_H
