#ifndef SIMIMPIGA_H

#define SIMIMPIGA_H

#include <mogal/mpigeneticalgorithm.h>
#include <string>

namespace shellp
{
	class IOSystem;
}

class SimiMPIGA : public mogal::MPIGeneticAlgorithm
{
public:
	SimiMPIGA(const std::string &translateCmd);
	~SimiMPIGA();
private:
	void onCurrentBest(const std::list<mogal::Genome *> &bestGenomes) const;
	void feedbackStatus(const std::string &str) const;
	void writeLog(int level, const char *fmt, ...);

	std::string m_translateCmd;
	bool m_gotTranslateCmd;
	mutable bool m_translateError;

	shellp::IOSystem *m_pIOSys;
};

#endif // SIMIMPIGA_H

