#include "simimpiga.h"
#include "simiconductorinstance.h"
#include "extproggenome.h"
#include <mogal/genome.h>
#include <shellp/fileptriosystem.h>
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <string.h>
#include <iostream>

#define MAXLEN 1024

using namespace mogal;
using namespace shellp;

#ifdef WIN32
#define popen _popen
#define pclose _pclose
#endif // WIN32

SimiMPIGA::SimiMPIGA(const std::string &translateCmd)
{
	m_translateError = false;
	if (translateCmd.length() == 0 || translateCmd == std::string("*"))
		m_gotTranslateCmd = false;
	else
	{
		m_translateCmd = translateCmd;
		m_gotTranslateCmd = true;
	}

	SimiConductorInstance *pInst = (SimiConductorInstance *)ShellInstance::getInstance();
	m_pIOSys = pInst->getIOSystem();
}

SimiMPIGA::~SimiMPIGA()
{
}

void SimiMPIGA::onCurrentBest(const std::list<Genome *> &bestGenomes) const
{
	if (bestGenomes.empty())
	{
		m_pIOSys->writeOutputLine("No best genome found yet");
	}
	else
	{
		ExtProgGenome *pGenome = (ExtProgGenome *)(*(bestGenomes.begin()));

		if (!m_gotTranslateCmd || m_translateError)
		{
			m_pIOSys->print("Current best (%.5g): %s", pGenome->getFitnessValues()[0], pGenome->getParameterString().c_str());
		}
		else
		{
			std::string cmd = m_translateCmd;
			std::string bestPointString = pGenome->getParameterString();

			cmd += std::string(" ");
			cmd += bestPointString;

			FILE *pFile = popen(cmd.c_str(), "r");
			if (pFile == 0)
			{
				m_translateError = true;
				m_pIOSys->print("Warning: couldn't execute translate command: %s", strerror(errno));
				m_pIOSys->print("Current best (%.5g): %s", pGenome->getFitnessValues()[0], pGenome->getParameterString().c_str());
			}
			else
			{
				m_pIOSys->print("Current best (%.5g):", pGenome->getFitnessValues()[0]);

				FilePtrIOSystem io(pFile, 0);
				std::string nullPrefix, line;
				
				while (io.readInputLine(nullPrefix, line))
					m_pIOSys->writeOutputLine(line);

				int status;

				if ((status = pclose(pFile)) != 0)
				{
					m_translateError = true;
					m_pIOSys->print("Warning: got non-zero return value (%d) from translate command", status);
					m_pIOSys->print("Current best (%.5g): %s", pGenome->getFitnessValues()[0], pGenome->getParameterString().c_str());
				}
			}
		}
	}
}

void SimiMPIGA::feedbackStatus(const std::string &str) const
{
	m_pIOSys->writeOutputLine("GA feedback: " + str);
}

void SimiMPIGA::writeLog(int level, const char *fmt, ...)
{
/*	va_list ap;
	char str[1024];

	va_start(ap, fmt);
	vsnprintf(str, 1024, fmt, ap);
	va_end(ap);

	std::cerr << "writeLog: " << str << std::endl;*/
}

