#ifndef SIMICONDUCTORREGION2D_H

#define SIMICONDUCTORREGION2D_H

#include <errut/errorbase.h>
#include <vector>

class SimiConductorRegion2D : public errut::ErrorBase
{
public:
	SimiConductorRegion2D()							{ }
	~SimiConductorRegion2D()							{ }

	virtual SimiConductorRegion2D *createCopy() const = 0;
	virtual std::string getDescription() const = 0;
	
	// Set the pixels INSIDE the region to true, leave the others alone
	// Return false if the region boundaries exceed the grid boundaries
	virtual bool fillPixels(std::vector<bool> &pixels, int width, int height) const = 0;
};

class SimiConductorRectRegion : public SimiConductorRegion2D
{
public:
	SimiConductorRectRegion(int x1, int y1, int x2, int y2);
	~SimiConductorRectRegion();

	SimiConductorRegion2D *createCopy() const;					
	virtual std::string getDescription() const;

	bool fillPixels(std::vector<bool> &pixels, int width, int height) const;
private:
	int m_x1, m_x2, m_y1, m_y2;
};

class SimiConductorMapRegion : public SimiConductorRegion2D
{
public:
	SimiConductorMapRegion();
	SimiConductorMapRegion(const std::vector<bool> map, int width, int height, int xOffset, int yOffset);
	~SimiConductorMapRegion();

	SimiConductorRegion2D *createCopy() const;
	virtual std::string getDescription() const;

	bool fillPixels(std::vector<bool> &pixels, int width, int height) const;

	bool import(const std::string &fileName, double xScale, double yScale, int xOffset, int yOffset);
private:
	std::vector<bool> m_map;
	int m_width, m_height;
	int m_xOffset, m_yOffset;
};

#endif // SIMICONDUCTORREGION2D_H

