#ifndef SIMICONDUCTORREGION1D_H

#define SIMICONDUCTORREGION1D_H

#include <errut/errorbase.h>
#include <vector>

class SimiConductorRegion1D : public errut::ErrorBase
{
public:
	SimiConductorRegion1D()								{ }
	~SimiConductorRegion1D()							{ }

	virtual SimiConductorRegion1D *createCopy() const = 0;
	virtual std::string getDescription() const = 0;
	
	// Set the pixels INSIDE the region to true, leave the others alone
	// Return false if the region boundaries exceed the grid boundaries
	virtual bool fillPixels(std::vector<bool> &pixels, int width) const = 0;
};

class SimiConductorLineRegion : public SimiConductorRegion1D
{
public:
	SimiConductorLineRegion(int x1, int x2);
	~SimiConductorLineRegion();

	SimiConductorRegion1D *createCopy() const;					
	virtual std::string getDescription() const;

	bool fillPixels(std::vector<bool> &pixels, int width) const;
private:
	int m_x1, m_x2;
};

#endif // SIMICONDUCTORREGION1D_H

