#include "simiconductorregion1d.h"
#include <stdio.h>

SimiConductorLineRegion::SimiConductorLineRegion(int x1, int x2)
{
	int tmp;

	if (x2 < x1)
	{
		tmp = x2;
		x2 = x1;
		x1 = tmp;
	}

	m_x1 = x1;
	m_x2 = x2;
}

SimiConductorLineRegion::~SimiConductorLineRegion()
{
}

SimiConductorRegion1D *SimiConductorLineRegion::createCopy() const					
{ 
	return new SimiConductorLineRegion(m_x1, m_x2); 
}

std::string SimiConductorLineRegion::getDescription() const
{
	char str[1024];

	sprintf(str, "Line: %d -> %d", m_x1, m_x2);

	return std::string(str);
}

bool SimiConductorLineRegion::fillPixels(std::vector<bool> &pixels, int width) const
{
	int xStart = m_x1-1;
	int xEnd = m_x2;

	if (xStart < 0 || xEnd > width )
	{
		setErrorString("Coordinates lie outside the current grid dimensions");
		return false;
	}

	for (int x = xStart ; x < xEnd ; x++)
		pixels[x] = true;

	return true;
}

