#ifndef SIMICONDUCTORINSTANCE_H

#define SIMICONDUCTORINSTANCE_H

#include "simiconductorregion1d.h"
#include "simiconductorregion2d.h"
#include <shellp/shellinstance.h>
#include <string>
#include <vector>
#include <list>
#include <map>

#define PLOTWINID_1DIV					256
#define PLOTWINID_2DIV					257

#define PLOTWINIDNAME_1DIV				"J(V) curve for 1D simulation"
#define PLOTWINIDNAME_2DIV				"J(V) curve for 2D simulation"

#define SIMI_CONSTNAME_X "X"
#define SIMI_CONSTNAME_PX "PX"
#define SIMI_CONSTNAME_Y "Y"
#define SIMI_CONSTNAME_PY "PY"
#define SIMI_CONSTNAME_V "V"
#define SIMI_CONSTNAME_NV "NV"

class Simulation1D;
class Simulation2D;
class SimulationState;

namespace mogal
{
	class GeneticAlgorithmParams;
}

class SimiConductorInstance : public shellp::ShellInstance
{
public:
	SimiConductorInstance();
	~SimiConductorInstance();

	bool isSaved() const;
	bool is1DSaved() const;
	bool is2DSaved() const;

	bool createNew1DRegionName(const std::string &regionName);
	bool append1DRegion(const std::string &regionName, const SimiConductorRegion1D &r);
	void get1DRegionNames(std::vector<std::string> &names);
	bool get1DRegions(const std::string &regionName, std::vector<const SimiConductorRegion1D *> &regions);
	bool delete1DRegion(const std::string &regionName);
	void clear1DRegions();

	bool createNew2DRegionName(const std::string &regionName);
	bool append2DRegion(const std::string &regionName, const SimiConductorRegion2D &r);
	void get2DRegionNames(std::vector<std::string> &names);
	bool get2DRegions(const std::string &regionName, std::vector<const SimiConductorRegion2D *> &regions);
	bool delete2DRegion(const std::string &regionName);
	void clear2DRegions();

	const mogal::GeneticAlgorithmParams *getGAParams() const						{ return m_pGAParams; }
	void setGAParams(mogal::GeneticAlgorithmParams *pParams);

	void setSimulationState1D(SimulationState *pState);
	SimulationState *getSimulationState1D() const;

	void setSimulationState2D(SimulationState *pState);
	SimulationState *getSimulationState2D() const;
private:
	bool internalCreateNew1DRegionName(const std::string &regionName);
	bool internalCreateNew2DRegionName(const std::string &regionName);
	bool internalDelete1DRegion(const std::string &regionName);
	bool internalDelete2DRegion(const std::string &regionName);
	void setupTotal1DRegion(const std::string &regionName, int numX);
	void setupTotal2DRegion(const std::string &regionName, int numX, int numY);

	std::map<std::string, std::list<SimiConductorRegion1D *> > m_1DregionMap;
	std::map<std::string, std::list<SimiConductorRegion2D *> > m_2DregionMap;

	mogal::GeneticAlgorithmParams *m_pGAParams;

	SimulationState *m_pSimState1D;
	SimulationState *m_pSimState2D;
};

#endif // SIMICONDUCTORINSTANCE_H

