#include "simulationstate.h"
#include "inversematrixpoissonsolver2d.h"
#include "inversematrixpoissonsolver1d.h"
#include <iostream>

int main(int argc, char *argv[])
{
	if (argc != 2)
	{
		std::cerr << "Specify a 2D simulation state" << std::endl;
		return -1;
	}

	std::string simStateFile(argv[1]);

	SimulationState state;

	if (!state.load(simStateFile))
	{
		std::cerr << state.getErrorString() << std::endl;
		return -1;
	}

	if (state.getDimensions() == 2)
	{
		std::cerr << "2D" << std::endl;

		InverseMatrixPoissonSolver2D solver;

		int numX = state.getNumberOfXPixels();
		int numY = state.getNumberOfYPixels();
		double width = state.getPixelWidth() * (double)numX;
		double height = state.getPixelHeight() * (double)(numY-1);

		if (!solver.init(numX, numY, width, height))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.setRelativePermittivity(state.getGridProperty(SIMSTATE_GRIDPROP_EPSREL)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.setPotentialDifference(state.getDoubleProperty(SIMSTATE_PROP_VDIFF)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.findPotential(state.getGridProperty(SIMSTATE_GRIDPROP_P),
					  state.getGridProperty(SIMSTATE_GRIDPROP_N)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		for (int y = 0 ; y < numY ; y++)
		{
			for (int x = 0 ; x < numX ; x++)
			{
				double val1 = state.getGridProperty(SIMSTATE_GRIDPROP_V, x, y);
				double val2 = solver.getPotential()[x+y*numX];
				std::cout << x << " " << y << " " << val1 << " " << val2 << " " << val2-val1 << std::endl;
			}
			std::cout << std::endl;
		}	
	}
	else if (state.getDimensions() == 1)
	{
		std::cerr << "1D" << std::endl;

		InverseMatrixPoissonSolver1D solver;

		int numX = state.getNumberOfXPixels();
		double width = state.getPixelWidth() * (double)(numX-1);

		if (!solver.init(numX, width))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.setRelativePermittivity(state.getGridProperty(SIMSTATE_GRIDPROP_EPSREL)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.setPotentialDifference(state.getDoubleProperty(SIMSTATE_PROP_VDIFF)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		if (!solver.findPotential(state.getGridProperty(SIMSTATE_GRIDPROP_P),
					  state.getGridProperty(SIMSTATE_GRIDPROP_N),
					  state.getGridProperty(SIMSTATE_GRIDPROP_BG)))
		{
			std::cerr << solver.getErrorString() << std::endl;
			return -1;
		}

		for (int x = 0 ; x < numX ; x++)
		{
			double val1 = state.getGridProperty(SIMSTATE_GRIDPROP_V, x);
			double val2 = solver.getPotential()[x];
			std::cout << x << " " << val1 << " " << val2 << " " << val2-val1 << std::endl;
		}	
		std::cout << std::endl;
	}
	return 0;
}
