#ifndef OPENCLKERNEL_H

#define OPENCLKERNEL_H

#include <errut/errorbase.h>
#ifdef OPENCL_OPENCL_CL_H
	#include <OpenCL/cl.h>
#else
	#include <CL/cl.h>
#endif // OPENCL_OPENCL_CL_H
#include <string>
#include <vector>

class OpenCLKernel : public errut::ErrorBase
{
public:
	OpenCLKernel();
	~OpenCLKernel();

	bool init(int numKernels = 1);
	bool loadProgram(const std::string &program, std::string &failLog);
	bool loadKernel(int idx, const std::string &kernelName);
	bool destroy();

	cl_context getContext()										{ return m_context; }
	cl_kernel getKernel(int idx = 0) 								{ return m_kernel[idx]; }
	cl_command_queue getCommandQueue()		 						{ return m_queue; }
private:
	static std::string getCLErrorString(int errNum);
	void releaseAll();

	bool m_init;
	std::string m_currentProgram;
	std::vector<std::string> m_currentKernelNames;
	
	cl_context m_context;
	cl_command_queue m_queue;
	cl_program m_program;
	std::vector<cl_kernel> m_kernel;
	cl_device_id *m_pDevices;
	int m_deviceIndex;
};

#endif // OPENCLKERNEL_H
