#ifndef NEWTONRAPHSONSEARCH_H

#define NEWTONRAPHSONSEARCH_H

#include <errut/errorbase.h>
#include <vector>

class NewtonRaphsonSearch : public errut::ErrorBase
{
public:
	NewtonRaphsonSearch();
	~NewtonRaphsonSearch();

	bool init(int dimension, bool useSparseSolver, bool useSparseElementAccess);
	bool step(double &sigma);
	int getDimension() const									{ return m_dimension; }
	
	const double *getValues() const									{ return &(m_functionValues[0]); }
	const double *getDifferences() const								{ return &(m_differences[0]); }

	void printMatrix() const;
	void getMatrix(std::vector<double> &m) const;
private:
	virtual int getMaxNonZeroRows(int col); // should be defined if the sparse _solver_ is used, and should not change after initialization

	virtual void startColumn(int col) = 0;
	virtual int getNextNonZeroRow() = 0; // should return -1 if no more entries

	virtual double getFunctionValue(int Findex) = 0;
	virtual double getDerivative(int Findex, int varIndex) = 0;

	int m_dimension;
	bool m_useSparseSolver;
	bool m_useSparseAccess;

	std::vector<int> m_colPointers;
	std::vector<int> m_nonzeroRows;
	std::vector<double> m_jacobianElements;
	std::vector<double> m_functionValues;
	std::vector<double> m_differences;
	void *m_pPerm;
};

#endif // NEWTONRAPHSONSEARCH_H
