#include "simiconductorconfig.h"
#include "simiconductorinstance.h"
#include <shellp/cmdeval.h>
#include <shellp/cmdexit.h>
#include <shellp/cmdecho.h>
#include <shellp/cmdhelp.h>
#include <shellp/cmdexec.h>
#include <shellp/cmdimport.h>
#include <shellp/cmdexport.h>
#include <shellp/cmddefine.h>
#include <shellp/cmddir.h>
#include <shellp/shellcmdrealarg.h>
#include "cmdsimulation1dnew.h"
#include "cmdsimulation2dnew.h"
#include "cmdregion1d.h"
#include "cmdregion2d.h"
#include "cmdevalmu.h"
#include "cmdrestart.h"
#include "cmdoptimize.h"

#include <iostream>
#include <string>
#include <list>

#include "dissociationprobability.h"
#include "simulation2ddouble.h"
#include "binimage.h"
#include <shellp/iosystem.h>
#include <stdio.h>


#include "simulation2dnr2.h"
#include <cmath>

#include "debugnew.h"

#if 0
class CmdTest : public shellp::ShellCommand
{
public:
	CmdTest(const std::string &cmdName) : shellp::ShellCommand(cmdName)
	{
		m_pFactor = new shellp::ShellCmdRealArg("factor");
		m_pFactor->setMin(0);
		m_pFactor->setMax(1);
		m_pFactor->setDescription("Factor");
		addArgument(m_pFactor);

		setDescription("Test");
	}

	~CmdTest()
	{
	}

	bool execute()
	{
		SimiConductorInstance *pInst = (SimiConductorInstance *)shellp::ShellInstance::getInstance();
		Simulation2D *pSim0 = pInst->getSimulation2D();

		Simulation2DNR2 *pSim = dynamic_cast<Simulation2DNR2 *>(pSim0);
		if (pSim0 == 0)
		{
			setErrorString("Not an NR2 type simulation");
			return false;
		}

		pSim->setPotentialCouplingFactor(m_pFactor->getValue());

		return true;
	}

	shellp::ShellCmdRealArg *m_pFactor;
};
#endif

class CmdVersion : public shellp::ShellCommand
{
public:
	CmdVersion(const std::string &name) : ShellCommand(name)
	{
		setDescription("Show simiconductor version");
	}

	~CmdVersion()
	{
	}

	bool execute()
	{
		SimiConductorInstance *pInst = (SimiConductorInstance *)shellp::ShellInstance::getInstance();
		shellp::IOSystem *pIOSys = pInst->getIOSystem();

		pIOSys->writeOutputLine("Version: " SIMICONDUCTOR_VERSION);

		return true;
	}
};

std::list<shellp::ShellCommand *> registeredCommands;

void RegisterCommands()
{
	registeredCommands.push_back(new CmdVersion("version"));
	registeredCommands.push_back(new CmdRestart("restart"));
	registeredCommands.push_back(new shellp::CmdExit("exit"));
	registeredCommands.push_back(new shellp::CmdExit("quit"));
	registeredCommands.push_back(new shellp::CmdHelp("help"));
	registeredCommands.push_back(new shellp::CmdExecute("exec"));
	registeredCommands.push_back(new shellp::CmdChangeDir("chdir"));
	registeredCommands.push_back(new shellp::CmdGetDir("getdir"));
	registeredCommands.push_back(new shellp::CmdEcho("echo"));
	registeredCommands.push_back(new shellp::CmdImport("import"));
	registeredCommands.push_back(new shellp::CmdExport("export"));
	registeredCommands.push_back(new shellp::CmdDefine("pre/def"));
	registeredCommands.push_back(new shellp::CmdListDefines("pre/list"));

	registeredCommands.push_back(new CmdSimulation1DNEWNew("sim1/new"));
	registeredCommands.push_back(new CmdSimulation1DNEWClear("sim1/clear"));
	registeredCommands.push_back(new CmdSimulation1DNEWSave("sim1/save"));
	registeredCommands.push_back(new CmdSimulation1DNEWLoad("sim1/load"));
	registeredCommands.push_back(new CmdSimulation1DNEWImport("sim1/import"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetRegionProperty("sim1/reg/set"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetRegionPropertyFormula("sim1/reg/formula"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetGridProperty("sim1/grid/set"));
	registeredCommands.push_back(new CmdSimulation1DNEWGetPixelProperty("sim1/grid/get"));
	registeredCommands.push_back(new CmdSimulation1DNEWInitDens("sim1/grid/init"));
	registeredCommands.push_back(new CmdSimulation1DNEWPlotGridProperty("sim1/grid/wplot"));
	registeredCommands.push_back(new CmdSimulation1DNEWFilePlotGridProperty("sim1/grid/fplot"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetPotentialDifference("sim1/phi/set"));
	registeredCommands.push_back(new CmdSimulation1DNEWShowPotentialDifference("sim1/phi/show"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetTemperature("sim1/temp/set"));
	registeredCommands.push_back(new CmdSimulation1DNEWShowTemperature("sim1/temp/show"));
	registeredCommands.push_back(new CmdSimulation1DNEWRun("sim1/run"));
	registeredCommands.push_back(new CmdSimulation1DNEWRunDirect("sim1/rundirect"));
	registeredCommands.push_back(new CmdSimulation1DNEWRunDirectMultiRes("sim1/rundirectmres"));
#ifdef SIMICONDUCTOR_CONFIG_AVE
	registeredCommands.push_back(new CmdSimulation1DNEWRunDirectAVE("sim1/rundirect/ave"));
#endif // SIMICONDUCTOR_CONFIG_AVE
	registeredCommands.push_back(new CmdSimulation1DNEWShowCurrent("sim1/xcur/show"));
	registeredCommands.push_back(new CmdSimulation1DNEWIVCurve("sim1/iv"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetExtendedRecombination("sim1/rec/ext"));
	registeredCommands.push_back(new CmdSimulation1DNEWSetBasicRecombinationModel("sim1/rec/basic"));
	registeredCommands.push_back(new CmdSimulation1DNEWGetRecombinationModel("sim1/rec/show"));
	registeredCommands.push_back(new CmdSimulation1DNEWGetAvgDissociationProbability("sim1/P/show"));
	
	registeredCommands.push_back(new CmdSimulation2DNEWNew("sim2/new"));
	registeredCommands.push_back(new CmdSimulation2DNEWClear("sim2/clear"));
	registeredCommands.push_back(new CmdSimulation2DNEWSave("sim2/save"));
	registeredCommands.push_back(new CmdSimulation2DNEWLoad("sim2/load"));
	registeredCommands.push_back(new CmdSimulation2DNEWImport("sim2/import"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetRegionProperty("sim2/reg/set"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetRegionPropertyFormula("sim2/reg/formula"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetRegionPropertyBIN("sim2/reg/bin"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetGridProperty("sim2/grid/set"));
	registeredCommands.push_back(new CmdSimulation2DNEWPlotGridProperty("sim2/grid/wplot"));
	registeredCommands.push_back(new CmdSimulation2DNEWFilePlotGridProperty("sim2/grid/fplot"));
	registeredCommands.push_back(new CmdSimulation2DNEWGetPixelProperty("sim2/grid/get"));
	registeredCommands.push_back(new CmdSimulation2DNEWInitDens("sim2/grid/init"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetPotentialDifference("sim2/phi/set"));
	registeredCommands.push_back(new CmdSimulation2DNEWShowPotentialDifference("sim2/phi/show"));
	registeredCommands.push_back(new CmdSimulation2DNEWSetTemperature("sim2/temp/set"));
	registeredCommands.push_back(new CmdSimulation2DNEWShowTemperature("sim2/temp/show"));
	registeredCommands.push_back(new CmdSimulation2DNEWRun("sim2/run"));
	registeredCommands.push_back(new CmdSimulation2DNEWRunDirect("sim2/rundirect"));
	registeredCommands.push_back(new CmdSimulation2DNEWRunDirectMultiRes("sim2/rundirectmres"));
	registeredCommands.push_back(new CmdSimulation2DNEWShowCurrent(false, "sim2/xcur/show"));
	registeredCommands.push_back(new CmdSimulation2DNEWShowCurrent(true, "sim2/ycur/show"));
	registeredCommands.push_back(new CmdSimulation2DNEWAvgPlot("sim2/avg/fplot"));
	registeredCommands.push_back(new CmdSimulation2DNEWLinePlot("sim2/line/fplot"));
	registeredCommands.push_back(new CmdSimulation2DNEWIVCurve("sim2/iv"));

	registeredCommands.push_back(new shellp::CmdEval("math/def", true, true));
	registeredCommands.push_back(new shellp::CmdEval("math/calc", true, false));
	registeredCommands.push_back(new CmdEvalMu("math/calc/mu"));
	registeredCommands.push_back(new shellp::CmdEvalList("math/list"));
	registeredCommands.push_back(new shellp::CmdEvalClearVar("math/clearvar"));
	registeredCommands.push_back(new CmdRegion1DNew("reg1/new"));
	registeredCommands.push_back(new CmdRegion1DAddLine("reg1/append/line"));
	registeredCommands.push_back(new CmdRegion1DDelete("reg1/delete"));
	registeredCommands.push_back(new CmdRegion1DClearAll("reg1/clearall"));
	registeredCommands.push_back(new CmdRegion1DList("reg1/list"));
	registeredCommands.push_back(new CmdRegion2DNew("reg2/new"));
	registeredCommands.push_back(new CmdRegion2DAddRect("reg2/append/rect"));
	registeredCommands.push_back(new CmdRegion2DAddImg("reg2/append/img"));
	registeredCommands.push_back(new CmdRegion2DDelete("reg2/delete"));
	registeredCommands.push_back(new CmdRegion2DClearAll("reg2/clearall"));
	registeredCommands.push_back(new CmdRegion2DList("reg2/list"));
	registeredCommands.push_back(new CmdOptimizeAmoeba("opt/amoeba"));
	
	//registeredCommands.push_back(new CmdTest("test"));
	
	registeredCommands.push_back(new CmdOptimizeGetGAParams("opt/gaparams/get"));
	registeredCommands.push_back(new CmdOptimizeSetGAParams("opt/gaparams/set"));
}

void UnregisterCommands()
{
	while (!registeredCommands.empty())
	{
		delete *(registeredCommands.begin());
		registeredCommands.pop_front();
	}
}

