#ifndef INVERSEMATRIXPOISSONSOLVER2D_H

#define INVERSEMATRIXPOISSONSOLVER2D_H

#include <errut/errorbase.h>
#include <vector>

//#define USEGSLFORTESTING
//#define DUMPMATRIX

#ifdef USEGSLFORTESTING
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_linalg.h>
#else
#include "klu.h"
#endif // USEGSLFORTESTING

// Periodic boundary conditions in X direction
class InverseMatrixPoissonSolver2D : public errut::ErrorBase
{
public:
	InverseMatrixPoissonSolver2D();
	~InverseMatrixPoissonSolver2D();
	bool init(int numX, int numY, double width, double height, double *pPotential = 0);
	bool setRelativePermittivity(const double *pEps);
	bool setPotentialDifference(double vDiff);
	bool findPotential(const double *pNetNumberCharge);
	bool findPotential(const double *pPosNumberCharge, const double *pNegNumberCharge);
	bool findPotential(const double *pPosNumberCharge, const double *pNegNumberCharge, const double *pBgNumberCharge);

	const double *getPotential() const								{ return m_pPotential; }
private:
#ifdef USEGSLFORTESTING
	std::vector<double> m_epsMatrixLU;
#else
#ifdef DUMPMATRIX
	std::vector<double> m_epsMatrixLU;
#endif // DUMPMATRIX
	std::vector<int> m_nonZeroRows;
	std::vector<double> m_epsSparseElements;
	std::vector<int> m_colPointers;
#endif // USEGSLFORTESTING
	std::vector<double> m_epsMatrix;
	std::vector<double> m_potential;
#ifdef USEGSLFORTESTING
	std::vector<double> m_charge;
#endif
	std::vector<double> m_topRowExtra;
	//std::vector<double> m_bottowRowExtra; // is zero since that potential is zero
	double m_potentialDifference;
	int m_numX, m_numY;
	double m_width, m_height;
	double m_dxOverDy, m_dyOverDx;
	double m_chargeFactor;
	double *m_pPotential;

#ifdef USEGSLFORTESTING
	gsl_permutation *m_pPerm;
	gsl_matrix_view m_epsMatrixLUView;
	gsl_vector_view m_chargeView;
	gsl_vector_view m_potentialView;
	int m_permSign;
#else
	klu_symbolic *m_pSymbolic;
	klu_numeric *m_pNumeric;
	klu_common m_common;
#endif // USEGSLFORTESTING
	bool m_hasLU;
};

#endif // INVERSEMATRIXPOISSONSOLVER2D_H
