#ifndef DISSOCIATIONPROBABILITY_H

#define DISSOCIATIONPROBABILITY_H

#include <gsl/gsl_integration.h>
#include <cmath>

class DissociationProbability
{
public:
	DissociationProbability(double electronHoleDistance, double T, double kf, gsl_integration_workspace *pWorkspace = 0);
	~DissociationProbability();

	double calculate(double rf, double epsilonRel, double F);
	double calculateDerivF(double rf, double epsilonRel, double F);
private:
	double integrationFunction(double x)
	{
		double x2 = x*x;
		double x3 = x2*x;
		double kdiss = (m_expPrefactor/x3)*std::exp(-m_expFactor/x);

		return 1.0/(1.0+m_kf/kdiss)*x2*std::exp(-x2);
	}

	static double staticIntegrationFunction(double x, void *pParams)
	{
		DissociationProbability *pInstance = (DissociationProbability *)pParams;
		return pInstance->integrationFunction(x);
	}

	double derivativeIntegrationFunction(double x)
	{
		double x2 = x*x;
		double x3 = x2*x;
		double kdiss = (m_expPrefactor/x3)*std::exp(-m_expFactor/x);
		double denom = 1.0+kdiss/m_kf;

		return 1.0/(denom*denom)*std::exp(-x2-m_expFactor/x)/x;
	}

	static double staticDerivativeIntegrationFunction(double x, void *pParams)
	{
		DissociationProbability *pInstance = (DissociationProbability *)pParams;
		return pInstance->derivativeIntegrationFunction(x);
	}

	double m_a, m_a3;
	double m_kTev, m_kTev2;
	double m_kf;

	double m_expFactor, m_expPrefactor;
	gsl_integration_workspace *m_pWorkSpace;
	bool m_deleteWorkSpace;
};

#endif // DISSOCIATIONPROBABILITY_H
