#ifndef CMDSIMULATION2DNEW_H

#define CMDSIMULATION2DNEW_H

#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdBoolArg;
	class ShellCmdIntArg;
	class ShellCmdRealArg;
	class ShellCmdStringArg;
	class ShellCmdChoiceArg;
}

class Simulation2D;
class SimulationState;
class Simulation2DNR2;

class CmdSimulation2DNEWClear : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWClear(const std::string &cmdName);
	~CmdSimulation2DNEWClear();
	bool execute();
private:
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation2DNEWNew : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWNew(const std::string &cmdName);
	~CmdSimulation2DNEWNew();
	bool execute();
private:
	shellp::ShellCmdIntArg *m_pNumXArg;
	shellp::ShellCmdIntArg *m_pNumYArg;
	shellp::ShellCmdRealArg *m_pWidthArg;;
	shellp::ShellCmdRealArg *m_pHeightArg;
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation2DNEWSave : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSave(const std::string &cmdName);
	~CmdSimulation2DNEWSave();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
};

class CmdSimulation2DNEWLoad : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWLoad(const std::string &cmdName);
	~CmdSimulation2DNEWLoad();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation2DNEWImport : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWImport(const std::string &cmdName);
	~CmdSimulation2DNEWImport();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pVarOnlyArg;
	shellp::ShellCmdBoolArg *m_pExcludeBorderArg;
};

class CmdSimulation2DNEWSetGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetGridProperty(const std::string &cmdName);
	~CmdSimulation2DNEWSetGridProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdIntArg *m_pX0;
	shellp::ShellCmdIntArg *m_pY0;
	shellp::ShellCmdIntArg *m_pX1;
	shellp::ShellCmdIntArg *m_pY1;
	shellp::ShellCmdRealArg *m_pValueArg;
};

class CmdSimulation2DNEWSetPotentialDifference : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetPotentialDifference(const std::string &cmdName);
	~CmdSimulation2DNEWSetPotentialDifference();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pPhiArg;
	shellp::ShellCmdBoolArg *m_pInitGridArg;
};

class CmdSimulation2DNEWRun : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWRun(const std::string &cmdName);
	~CmdSimulation2DNEWRun();
	bool execute();
private:
	std::string replaceString(const std::string &str, const std::string &findStr, const std::string &replaceStr);
	shellp::ShellCmdIntArg *m_pStepsArg;
	shellp::ShellCmdRealArg *m_pDtArg;
	shellp::ShellCmdIntArg *m_pShowCurrentsStepsArg;
	shellp::ShellCmdStringArg *m_pSaveIntNameArg;
	shellp::ShellCmdIntArg *m_pSaveIntStepsArg;
	shellp::ShellCmdStringArg *m_pPlotFileNameArg;
	shellp::ShellCmdIntArg *m_pPlotFileStepsArg;
	shellp::ShellCmdIntArg *m_pPlotWindowStepsArg;
	shellp::ShellCmdChoiceArg *m_pTypeArg;
	shellp::ShellCmdBoolArg *m_pInverseSolverArg;
};

class CmdSimulation2DNEWPlotGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWPlotGridProperty(const std::string &cmdName);
	~CmdSimulation2DNEWPlotGridProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
};

class CmdSimulation2DNEWShowPotentialDifference : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWShowPotentialDifference(const std::string &cmdName);
	~CmdSimulation2DNEWShowPotentialDifference();
	bool execute();
};

class CmdSimulation2DNEWShowCurrent : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWShowCurrent(bool yCurrent, const std::string &cmdName);
	~CmdSimulation2DNEWShowCurrent();
	bool execute();
private:
	bool m_yCurrent;
};

class CmdSimulation2DNEWFilePlotGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWFilePlotGridProperty(const std::string &cmdName);
	~CmdSimulation2DNEWFilePlotGridProperty();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pAppendArg;
};

class CmdSimulation2DNEWSetRegionProperty : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetRegionProperty(const std::string &cmdName);
	~CmdSimulation2DNEWSetRegionProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdRealArg *m_pValueArg;
};

class CmdSimulation2DNEWGetPixelProperty : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWGetPixelProperty(const std::string &cmdName);
	~CmdSimulation2DNEWGetPixelProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdIntArg *m_pXArg;
	shellp::ShellCmdIntArg *m_pYArg;
	shellp::ShellCmdStringArg *m_pVarName;
};


class CmdSimulation2DNEWAvgPlot : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWAvgPlot(const std::string &cmdName);
	~CmdSimulation2DNEWAvgPlot();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdChoiceArg *m_pXYArg;
};

class CmdSimulation2DNEWLinePlot : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWLinePlot(const std::string &cmdName);
	~CmdSimulation2DNEWLinePlot();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdIntArg *m_pCoordArg;
	shellp::ShellCmdChoiceArg *m_pXYArg;
};

class CmdSimulation2DNEWRunDirect : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWRunDirect(const std::string &cmdName);
	~CmdSimulation2DNEWRunDirect();
	bool execute();

	static bool searchEquilibrium(Simulation2D *pSim, int maxIterations, bool showCurrent, 
		bool errorOnMaxCount, double errorTolerance, int &iterations, std::string &errStr,
		double stopTime, bool runNPfirst = false, bool runVfirst = false, bool stopAfterNP = false);
protected:
	bool searchEquilibrium(Simulation2D *pSim, int maxIterations, bool showCurrent, 
		bool errorOnMaxCount, double errorTolerance, int &iterations, double stopTime,
		bool runNPfirst = false, bool runVfirst = false, bool stopAfterNP = false)
	{
		std::string errStr;

		bool status = searchEquilibrium(pSim, maxIterations, showCurrent, errorOnMaxCount, errorTolerance, iterations, errStr, stopTime, runNPfirst, runVfirst, stopAfterNP);

		if (!status)
			setErrorString(errStr);
		return status;
	}

	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdBoolArg *m_pShowCurrentsArg;
	shellp::ShellCmdRealArg *m_pErrorArg;
	shellp::ShellCmdRealArg *m_pTimeArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
	shellp::ShellCmdBoolArg *m_pNPOnlyArg;
};

class CmdSimulation2DNEWInitDens : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWInitDens(const std::string &cmdName);
	~CmdSimulation2DNEWInitDens();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
	shellp::ShellCmdBoolArg *m_pUseVExtraArg;
};

class CmdSimulation2DNEWRunDirectMultiRes : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWRunDirectMultiRes(const std::string &cmdName);
	~CmdSimulation2DNEWRunDirectMultiRes();
	bool execute();
private:
	bool transferState(const Simulation2DNR2 *pPrevSim, int newX, int newY,
		                                        double realWidth, double realHeight,
							const SimulationState &highResState,
							SimulationState &newState);
	Simulation2DNR2 *createSimAndImport(int numX, int numY, double realWidth, 
								        double realHeight, double T,
									double diffScale, double densScale,
									bool useLog, SimulationState &state);

	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdBoolArg *m_pShowCurrentsArg;
	shellp::ShellCmdIntArg *m_pMinXArg;
	shellp::ShellCmdIntArg *m_pMinYArg;
	shellp::ShellCmdIntArg *m_pStepsArg;
	shellp::ShellCmdRealArg *m_pErrorArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdRealArg *m_pTimeArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
};

class CmdSimulation2DNEWIVCurve : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWIVCurve(const std::string &cmdName);
	~CmdSimulation2DNEWIVCurve();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pVIntArg;
	shellp::ShellCmdRealArg *m_pVStartArg;
	shellp::ShellCmdRealArg *m_pVStopArg;
	shellp::ShellCmdIntArg *m_pNumStepsArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pAppendArg;
	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdRealArg *m_pErrorArg;
	shellp::ShellCmdRealArg *m_pTimeArg;
	shellp::ShellCmdBoolArg *m_pDoubleSearchArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
	shellp::ShellCmdBoolArg *m_pWarnError;
};

class CmdSimulation2DNEWSetRegionPropertyFormula : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetRegionPropertyFormula(const std::string &cmdName);
	~CmdSimulation2DNEWSetRegionPropertyFormula();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdStringArg *m_pFormulaArg;
};

class CmdSimulation2DNEWSetRegionPropertyBIN : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetRegionPropertyBIN(const std::string &cmdName);
	~CmdSimulation2DNEWSetRegionPropertyBIN();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdStringArg *m_pBINFileArg;
	shellp::ShellCmdStringArg *m_pFormulaArg;
};

class CmdSimulation2DNEWSetRegionPropertyImage : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetRegionPropertyImage(const std::string &cmdName);
	~CmdSimulation2DNEWSetRegionPropertyImage();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdStringArg *m_pImageFileArg;
	shellp::ShellCmdBoolArg *m_pAutoScaleArg;
	shellp::ShellCmdStringArg *m_pFormulaArg;
};

class CmdSimulation2DNEWSetTemperature : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWSetTemperature(const std::string &cmdName);
	~CmdSimulation2DNEWSetTemperature();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pTemp;
};

class CmdSimulation2DNEWShowTemperature : public shellp::ShellCommand
{
public:
	CmdSimulation2DNEWShowTemperature(const std::string &cmdName);
	~CmdSimulation2DNEWShowTemperature();
	bool execute();
};


#endif // CMDSIMULATION2DNEW_H

