#ifndef CMDSIMULATION1DNEW_H

#define CMDSIMULATION1DNEW_H

#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdBoolArg;
	class ShellCmdIntArg;
	class ShellCmdRealArg;
	class ShellCmdStringArg;
	class ShellCmdChoiceArg;
}

class Simulation1D;
class Simulation1DNR;
class SimulationState;

class CmdSimulation1DNEWClear : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWClear(const std::string &cmdName);
	~CmdSimulation1DNEWClear();
	bool execute();
private:
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation1DNEWNew : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWNew(const std::string &cmdName);
	~CmdSimulation1DNEWNew();
	bool execute();
private:
	shellp::ShellCmdIntArg *m_pNumXArg;
	shellp::ShellCmdRealArg *m_pWidthArg;
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation1DNEWSave : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSave(const std::string &cmdName);
	~CmdSimulation1DNEWSave();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
};

class CmdSimulation1DNEWLoad : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWLoad(const std::string &cmdName);
	~CmdSimulation1DNEWLoad();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pForceArg;
};

class CmdSimulation1DNEWSetGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetGridProperty(const std::string &cmdName);
	~CmdSimulation1DNEWSetGridProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdIntArg *m_pX0;
	shellp::ShellCmdIntArg *m_pX1;
	shellp::ShellCmdRealArg *m_pValueArg;
};

class CmdSimulation1DNEWSetPotentialDifference : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetPotentialDifference(const std::string &cmdName);
	~CmdSimulation1DNEWSetPotentialDifference();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pPhiArg;
	shellp::ShellCmdBoolArg *m_pInitGridArg;
};

class CmdSimulation1DNEWImport : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWImport(const std::string &cmdName);
	~CmdSimulation1DNEWImport();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
};

class CmdSimulation1DNEWShowPotentialDifference : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWShowPotentialDifference(const std::string &cmdName);
	~CmdSimulation1DNEWShowPotentialDifference();
	bool execute();
};

class CmdSimulation1DNEWPlotGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWPlotGridProperty(const std::string &cmdName);
	~CmdSimulation1DNEWPlotGridProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
};

class CmdSimulation1DNEWFilePlotGridProperty : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWFilePlotGridProperty(const std::string &cmdName);
	~CmdSimulation1DNEWFilePlotGridProperty();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pAppendArg;
};

class CmdSimulation1DNEWSetRegionProperty : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetRegionProperty(const std::string &cmdName);
	~CmdSimulation1DNEWSetRegionProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdRealArg *m_pValueArg;
};


class CmdSimulation1DNEWGetPixelProperty : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWGetPixelProperty(const std::string &cmdName);
	~CmdSimulation1DNEWGetPixelProperty();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdIntArg *m_pXArg;
	shellp::ShellCmdStringArg *m_pVarName;
};

class CmdSimulation1DNEWInitDens : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWInitDens(const std::string &cmdName);
	~CmdSimulation1DNEWInitDens();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
};

class CmdSimulation1DNEWSetRegionPropertyFormula : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetRegionPropertyFormula(const std::string &cmdName);
	~CmdSimulation1DNEWSetRegionPropertyFormula();
	bool execute();
private:
	shellp::ShellCmdChoiceArg *m_pPropertyArg;
	shellp::ShellCmdStringArg *m_pRegionArg;
	shellp::ShellCmdStringArg *m_pFormulaArg;
};

class CmdSimulation1DNEWShowCurrent : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWShowCurrent(const std::string &cmdName);
	~CmdSimulation1DNEWShowCurrent();
	bool execute();
};

class CmdSimulation1DNEWSetExtendedRecombination : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetExtendedRecombination(const std::string &cmdName);
	~CmdSimulation1DNEWSetExtendedRecombination();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pPairDistArg;
	shellp::ShellCmdRealArg *m_pGroundStateDecayRateArg;
};

class CmdSimulation1DNEWSetBasicRecombinationModel : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetBasicRecombinationModel(const std::string &cmdName);
	~CmdSimulation1DNEWSetBasicRecombinationModel();
	bool execute();
};

class CmdSimulation1DNEWGetRecombinationModel : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWGetRecombinationModel(const std::string &cmdName);
	~CmdSimulation1DNEWGetRecombinationModel();
	bool execute();
};

class CmdSimulation1DNEWGetAvgDissociationProbability : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWGetAvgDissociationProbability(const std::string &cmdName);
	~CmdSimulation1DNEWGetAvgDissociationProbability();
	bool execute();
};

class CmdSimulation1DNEWRunDirect : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWRunDirect(const std::string &cmdName);
	~CmdSimulation1DNEWRunDirect();
	bool execute();

	static bool searchEquilibrium(Simulation1D *pSim, int maxIterations, bool showCurrent, 
		bool errorOnMaxCount, double errorTolerance, int &iterations, std::string &errStr);
protected:
	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdBoolArg *m_pShowCurrentsArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
};

class CmdSimulation1DNEWSetTemperature : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWSetTemperature(const std::string &cmdName);
	~CmdSimulation1DNEWSetTemperature();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pTemp;
};

class CmdSimulation1DNEWShowTemperature : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWShowTemperature(const std::string &cmdName);
	~CmdSimulation1DNEWShowTemperature();
	bool execute();
};

class CmdSimulation1DNEWIVCurve : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWIVCurve(const std::string &cmdName);
	~CmdSimulation1DNEWIVCurve();
	bool execute();

	static void finishFile(FILE *pFile, const std::vector<double> &V, const std::vector<double> &J);
	static bool findVoc(const std::vector<double> &V, const std::vector<double> &J, double &Voc);
private:
	shellp::ShellCmdRealArg *m_pVIntArg;
	shellp::ShellCmdRealArg *m_pVStartArg;
	shellp::ShellCmdRealArg *m_pVStopArg;
	shellp::ShellCmdIntArg *m_pNumStepsArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdBoolArg *m_pAppendArg;
	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdRealArg *m_pErrorArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
	shellp::ShellCmdBoolArg *m_pWarnError;
};

class CmdSimulation1DNEWRunDirectMultiRes : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWRunDirectMultiRes(const std::string &cmdName);
	~CmdSimulation1DNEWRunDirectMultiRes();
	bool execute();
private:
	bool transferState(const Simulation1DNR *pPrevSim, int newX, 
		                                        double realWidth, const SimulationState &highResState,
							SimulationState &newState);
	Simulation1DNR *createSimAndImport(int numX, double realWidth, double T,
									double diffScale, double densScale,
									bool useLog, SimulationState &state);

	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdBoolArg *m_pShowCurrentsArg;
	shellp::ShellCmdIntArg *m_pMinXArg;
	shellp::ShellCmdIntArg *m_pStepsArg;
	shellp::ShellCmdRealArg *m_pErrorArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
};

class CmdSimulation1DNEWRun : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWRun(const std::string &cmdName);
	~CmdSimulation1DNEWRun();
	bool execute();
private:
	std::string replaceString(const std::string &str, const std::string &findStr, const std::string &replaceStr);
	shellp::ShellCmdIntArg *m_pStepsArg;
	shellp::ShellCmdRealArg *m_pDtArg;
	shellp::ShellCmdIntArg *m_pShowCurrentsStepsArg;
	shellp::ShellCmdStringArg *m_pSaveIntNameArg;
	shellp::ShellCmdIntArg *m_pSaveIntStepsArg;
	shellp::ShellCmdStringArg *m_pPlotFileNameArg;
	shellp::ShellCmdIntArg *m_pPlotFileStepsArg;
	shellp::ShellCmdIntArg *m_pPlotWindowStepsArg;
	shellp::ShellCmdBoolArg *m_pInverseMatrixSolver;
};

class CmdSimulation1DNEWRunDirectAVE : public shellp::ShellCommand
{
public:
	CmdSimulation1DNEWRunDirectAVE(const std::string &cmdName);
	~CmdSimulation1DNEWRunDirectAVE();
	bool execute();

	static bool searchEquilibrium(Simulation1D *pSim, int maxIterations, bool showCurrent, 
		bool errorOnMaxCount, double errorTolerance, int &iterations, std::string &errStr);
protected:
	shellp::ShellCmdIntArg *m_pMaxIterationsArg;
	shellp::ShellCmdBoolArg *m_pShowCurrentsArg;
	shellp::ShellCmdRealArg *m_pDensArg;
	shellp::ShellCmdRealArg *m_pDiffArg;
	shellp::ShellCmdBoolArg *m_pLogArg;
};

#endif // CMDSIMULATION1DNEW_H

