#include "cmdrestart.h"
#include "simiconductorinstance.h"
#include <shellp/shellcmdboolarg.h>

using namespace shellp;

CmdRestart::CmdRestart(const std::string &cmdName) : ShellCommand(cmdName)
{
	m_pForceArg = new ShellCmdBoolArg("force", "no");
	m_pForceArg->setDescription("In interactive mode, enabling this flag forces a new grid even if the previous one hasn't been saved. Ignored in non-interactive mode.");
	addArgument(m_pForceArg);

	setDescription("Clears simulation, regions and all newly defined symbols.");
}

CmdRestart::~CmdRestart()
{
	delete m_pForceArg;
}

bool CmdRestart::execute()
{
	SimiConductorInstance *pInst = (SimiConductorInstance *)ShellInstance::getInstance();

	if (pInst->isInteractive())
	{
		bool force = m_pForceArg->getValue();

		if (! (force || (!force && pInst->isSaved())) )
		{
			setErrorString("Simulation not saved, specify force flag to override");
			return false;
		}
	}

	pInst->clearVariables();
	pInst->clear1DRegions();
	pInst->clear2DRegions();
	//pInst->setSimulation1D(0);
	//pInst->setSimulation2D(0);
	pInst->setSimulationState1D(0);
	pInst->setSimulationState2D(0);
	//pInst->set1DSavedFlag(true);
	//pInst->set2DSavedFlag(true);
	
	return true;
}
