#ifndef CMDREGION2D_H

#define CMDREGION2D_H

#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdStringArg;
	class ShellCmdIntArg;
	class ShellCmdRealArg;
	class ShellCmdBoolArg;
}

class CmdRegion2DNew : public shellp::ShellCommand
{
public:
	CmdRegion2DNew(const std::string &cmdName);
	~CmdRegion2DNew();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
};

class CmdRegion2DAddRect : public shellp::ShellCommand
{
public:
	CmdRegion2DAddRect(const std::string &cmdName);
	~CmdRegion2DAddRect();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
	shellp::ShellCmdIntArg *m_pX1Arg;
	shellp::ShellCmdIntArg *m_pY1Arg;
	shellp::ShellCmdIntArg *m_pX2Arg;
	shellp::ShellCmdIntArg *m_pY2Arg;
};

class CmdRegion2DAddImg : public shellp::ShellCommand
{
public:
	CmdRegion2DAddImg(const std::string &cmdName);
	~CmdRegion2DAddImg();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
	shellp::ShellCmdStringArg *m_pFileNameArg;
	shellp::ShellCmdRealArg *m_pXScaleArg;
	shellp::ShellCmdRealArg *m_pYScaleArg;
	shellp::ShellCmdIntArg *m_pXOffsetArg;
	shellp::ShellCmdIntArg *m_pYOffsetArg;
};

class CmdRegion2DDelete : public shellp::ShellCommand
{
public:
	CmdRegion2DDelete(const std::string &cmdName);
	~CmdRegion2DDelete();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
};

class CmdRegion2DClearAll : public shellp::ShellCommand
{
public:
	CmdRegion2DClearAll(const std::string &cmdName);
	~CmdRegion2DClearAll();
	bool execute();
};

class CmdRegion2DList : public shellp::ShellCommand
{
public:
	CmdRegion2DList(const std::string &cmdName);
	~CmdRegion2DList();
	bool execute();
private:
	shellp::ShellCmdBoolArg *m_pPrintDescArg;
};

#endif // CMDREGION2D_H
