#ifndef CMDREGION1D_H

#define CMDREGION1D_H

#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdStringArg;
	class ShellCmdIntArg;
	class ShellCmdRealArg;
	class ShellCmdBoolArg;
}

class CmdRegion1DNew : public shellp::ShellCommand
{
public:
	CmdRegion1DNew(const std::string &cmdName);
	~CmdRegion1DNew();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
};

class CmdRegion1DAddLine : public shellp::ShellCommand
{
public:
	CmdRegion1DAddLine(const std::string &cmdName);
	~CmdRegion1DAddLine();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
	shellp::ShellCmdIntArg *m_pX1Arg;
	shellp::ShellCmdIntArg *m_pX2Arg;
};

class CmdRegion1DDelete : public shellp::ShellCommand
{
public:
	CmdRegion1DDelete(const std::string &cmdName);
	~CmdRegion1DDelete();
	bool execute();
private:
	shellp::ShellCmdStringArg *m_pNameArg;
};

class CmdRegion1DClearAll : public shellp::ShellCommand
{
public:
	CmdRegion1DClearAll(const std::string &cmdName);
	~CmdRegion1DClearAll();
	bool execute();
};

class CmdRegion1DList : public shellp::ShellCommand
{
public:
	CmdRegion1DList(const std::string &cmdName);
	~CmdRegion1DList();
	bool execute();
private:
	shellp::ShellCmdBoolArg *m_pPrintDescArg;
};

#endif // CMDREGION1D_H

