#ifndef CMDOPTIMIZEMPI_H

#define CMDOPTIMIZEMPI_H

#include "simiconductorconfig.h"
#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdStringArg;
	class ShellCmdRealArg;
	class ShellCmdIntArg;
	class ShellCmdBoolArg;
	class ShellCmdChoiceArg;
}

class CmdOptimizeMPIGASingle : public shellp::ShellCommand
{
public:
	CmdOptimizeMPIGASingle(const std::string &cmdName);
	~CmdOptimizeMPIGASingle();

	bool execute();
private:
	shellp::ShellCmdIntArg *m_pNumParamArg;
	shellp::ShellCmdIntArg *m_pPopSizeArg;
	shellp::ShellCmdStringArg *m_pCommandArg;
	shellp::ShellCmdStringArg *m_pTranslateCommandArg;
};

class CmdOptimizeMPIGAMulti : public shellp::ShellCommand
{
public:
	CmdOptimizeMPIGAMulti(const std::string &cmdName);
	~CmdOptimizeMPIGAMulti();

	bool execute();
private:
	shellp::ShellCmdIntArg *m_pNumParamArg;
	shellp::ShellCmdIntArg *m_pNumFitnessArg;
	shellp::ShellCmdIntArg *m_pPopSizeArg;
	shellp::ShellCmdStringArg *m_pCommandArg;
	shellp::ShellCmdStringArg *m_pTranslateCommandArg;
};

#endif // CMDOPTIMIZEMPI_H
