#ifndef CMDOPTIMIZE_H

#define CMDOPTIMIZE_H

#include "simiconductorconfig.h"
#include <shellp/shellcommand.h>

namespace shellp
{
	class ShellCmdStringArg;
	class ShellCmdRealArg;
	class ShellCmdIntArg;
	class ShellCmdBoolArg;
	class ShellCmdChoiceArg;
}

class CmdOptimizeAmoeba : public shellp::ShellCommand
{
public:
	CmdOptimizeAmoeba(const std::string &cmdName);
	~CmdOptimizeAmoeba();
	bool execute();
private:
	shellp::ShellCmdIntArg *m_pNumParamArg;
	shellp::ShellCmdStringArg *m_pCommandArg;
	shellp::ShellCmdStringArg *m_pTranslateCommandArg;
};

class CmdOptimizeGetGAParams : public shellp::ShellCommand
{
public:
	CmdOptimizeGetGAParams(const std::string &cmdName);
	~CmdOptimizeGetGAParams();
	bool execute();
};

class CmdOptimizeSetGAParams : public shellp::ShellCommand
{
public:
	CmdOptimizeSetGAParams(const std::string &cmdName);
	~CmdOptimizeSetGAParams();
	bool execute();
private:
	shellp::ShellCmdRealArg *m_pBetaArg;
	shellp::ShellCmdBoolArg *m_pElitismArg;
	shellp::ShellCmdBoolArg *m_pIncludeBest;
	shellp::ShellCmdRealArg *m_pCrossArg;
};

#endif // CMDOPTIMIZE_H
