#ifndef BINIMAGE_H

#define BINIMAGE_H

#include "simiconductorconfig.h"
#include <errut/errorbase.h>
#include <stdint.h>
#include <vector>

class BinImage : public errut::ErrorBase
{
public:
	BinImage();
	~BinImage();
	bool load(const std::string &fileName, bool flipX = false, bool flipY = false);
	bool save(const std::string &fileName) const;
	bool init(int width, int height);
	bool importImage(const std::string &fileName);
	bool exportImage(const std::string &fileName, int minValue = -1, int maxValue = -1) const;

	bool resize(int width, int height);

	int getWidth() const										{ return m_width; }
	int getHeight() const										{ return m_height; }
	bool getMinMax(uint16_t &min, uint16_t &max) const;

	uint16_t getPixel(int x, int y) const								{ return m_values[x+y*m_width]; }
	void setPixel(int x, int y, uint16_t value)							{ m_values[x+y*m_width] = value; }
private:
	double integrate(double x1, double x2, double y1, double y2) const;
	
	int m_width, m_height;
	std::vector<uint16_t> m_values;
};

#endif // BINIMAGE_H
