#!/usr/bin/env python

from simiexception import SimiException

class RegionProperties:
    def __init__(self):
        self.m_epsRel = -1
        self.m_eMob = -1
        self.m_hMob = -1
        self.m_eDiff = -1
        self.m_hDiff = -1
        self.m_lumo = -1
        self.m_homo = -1
        self.m_generationRate = -1
        self.m_recFactor = -1
        self.m_bg = 0

        self.m_name = "NoName"

    def setMobilities(self, eMob, hMob):
        self.m_eMob = eMob
        self.m_hMob = hMob

    def setDiffusionConstants(self, eDiff, hDiff)
        self.m_eDiff = eDiff
        self.m_hDiff = hDiff

    def setMobilitiesDiffusionEinstein(self, eMob, hMob, T):
        self.m_eMob = eMob
        self.m_hMob = hMob
        k = 1.3806488e-23   # Boltzmann constant
        e = 1.60217657e-19  # Electron charge
        kT_ev = T*k/e
        self.m_eDiff = kT_ev*eMob
        self.m_hDiff = kT_ev*hMob

    def setEnergyLevels(self, lumo, homo):
        self.m_lumo = lumo
        self.m_homo = homo

    def setRelativePermittivity(self, epsRel):
        self.m_epsRel = epsRel

    def setGenerationRate(self, generationRate):
        self.m_generationRate = generationRate

    def setRecombinationFactor(self, recFactor):
        self.m_recFactor = recFactor

    def setBackgroundNumberDensity(self, bg):
        self.m_bg = bg

    def setName(self, name):
        self.m_name = name

