#!/usr/bin/env python

import simiexception
from PySide import QtCore, QtGui

SimiException = simiexception.SimiException

class RegionImage:
    def __init__(self, filename, MAXREGIONS=16):
        self.m_numX = 0
        self.m_numY = 0
        self.m_img = None
        self.m_regionColor = [ ]

        img = QtGui.QImage()
        if not img.load(filename):
            raise SimiException("Unable to open image file " + filename)

        self.m_numX = img.width()
        self.m_numY = img.height()

        colorMap = { }

        for x in range(0, self.m_numX):
            for y in range(0, self.m_numY):
                col = img.pixel(x, y)
                colorMap[col] = True
                if len(colorMap) > MAXREGIONS:
                    raise SimiException("Image contains more than " + str(MAXREGIONS) + " colors (regions)")

        for i in colorMap:
            self.m_regionColor.append(i)

        self.m_img = [ 0 for i in range(0, self.m_numX*self.m_numY) ]
        for x in range(0, self.m_numX):
            for y in range(0, self.m_numY):
                col = img.pixel(x, y)
                idx = self.m_regionColor.index(col)
                self.m_img[x+(self.m_numY-1-y)*self.m_numX] = idx

        self.m_physWidth = str(1e-9 * self.m_numX)
        self.m_physHeight = str(1e-9 * self.m_numY)
        self.m_temperature = 300.0

    def __str__(self):
        return str(self.m_numX) + "x" + str(self.m_numY) + " " + str(self.m_physWidth) + "x" + str(self.m_physHeight) 

    def getNumRegions(self):
        return len(self.m_regionColor)

    def getRegionColor(self, idx):
        return self.m_regionColor[idx]

    def getWidth(self):
        return self.m_numX

    def getHeight(self):
        return self.m_numY

    def getRegionIndex(self, x, y):
        return self.m_img[x+y*self.m_numX]

    def getPhysicalWidth(self):
        return self.m_physWidth

    def getPhysicalHeight(self):
        return self.m_physHeight

    def getTemperature(self):
        return self.m_temperature

    def printMap(self):
        for y in range(0, self.m_numY):
            for x in range(0, self.m_numX):
                print str(self.getRegionIndex(x, y)),
            print

    def setTemperature(self, T):
        self.m_temperature = T

    def setPhysicalWidth(self, w):
        self.m_physWidth = w

    def setPhysicalHeight(self, h):
        self.m_physHeight = h
    
    def copyPixelDimensions(self, src):
        pixW = float(src.m_physWidth)/src.m_numX
        pixH = float(src.m_physHeight)/(src.m_numY-1)
        self.m_physWidth = str(pixW*self.m_numX)
        self.m_physHeight = str(pixH*(self.m_numY-1))

if __name__ == "__main__":
    r = RegionImage("/tmp/twoareas.png")
    print r
    print 

    r.printMap()
