from PySide import QtCore, QtGui
import ui_matpropwidget

class MatPropWidget(QtGui.QWidget):
    def __init__(self, tabParent = None):
        super(MatPropWidget, self).__init__(tabParent)

        self.ui = ui_matpropwidget.Ui_MatPropWidget()
        self.ui.setupUi(self)

        self.recButtonGroup = QtGui.QButtonGroup(self)
        self.recButtonGroup.addButton(self.ui.langevinButton)
        self.recButtonGroup.addButton(self.ui.recValueButton)
        self.ui.langevinButton.setChecked(True)
        self.tabParent = tabParent

#        validator = QtGui.QDoubleValidator(self)
#        validator.setRange(0,1e50)
#        self.ui.eMob.setValidator(validator)
#        self.ui.hMob.setValidator(validator)
#        self.ui.genRate.setValidator(validator)
#        self.ui.recFactor.setValidator(validator)

        self.ui.matName.textChanged.connect(self.onNameChanged)
        self.selectedColor = None

    def getMaterialName(self):
        return self.ui.matName.text()

    def onNameChanged(self, name):
        idx = self.tabParent.currentIndex()
        self.tabParent.setTabText(idx, name)

    def setMaterialColor(self, col):
        widget = self.ui.matColorButton
        widget.setAutoFillBackground(True)
        widget.setStyleSheet("background-color: rgb(" + str(QtGui.qRed(col)) + "," + str(QtGui.qGreen(col)) + "," + str(QtGui.qBlue(col)) +")")
        self.selectedColor = col

    def getSelectedColor(self):
        return self.selectedColor

    def getCleanedName(self):
        name = self.getMaterialName()
        cleanedName = ""
        validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890"
        for c in name:
            if not c in validChars:
                cleanedName += "_"
            else:
                cleanedName += c

        return cleanedName

    def getLUMO(self):
        return self.ui.LUMO.value()

    def getHOMO(self):
        return self.ui.HOMO.value()

    def getGenerationRate(self):
        return self.ui.genRate.text()

    def getRecombinationFactor(self):
        return self.ui.recFactor.text()

    def getElectronMobility(self):
        return self.ui.eMob.text()

    def getHoleMobility(self):
        return self.ui.hMob.text()

    def getRelativePermittivity(self):
        return self.ui.epsRel.value()

    def isLangevin(self):
        return self.ui.langevinButton.isChecked()

    def getState(self):
        state = { }
        state['name'] = self.getMaterialName()
        state['color'] = self.selectedColor
        state['lumo'] = self.getLUMO()
        state['homo'] = self.getHOMO()
        state['G'] = self.getGenerationRate()
        state['rFactorValue'] = self.getRecombinationFactor()
        state['isLangevin'] = self.isLangevin()
        state['eMob'] = self.getElectronMobility()
        state['hMob'] = self.getHoleMobility()
        state['eps'] = self.getRelativePermittivity()

        return state

    def setState(self, state):
        self.ui.matName.setText(state['name'])
        if state['color']:
            self.setMaterialColor(state['color'])
        self.ui.LUMO.setValue(state['lumo'])
        self.ui.HOMO.setValue(state['homo'])
        self.ui.genRate.setText(state['G'])
        self.ui.recFactor.setText(state['rFactorValue'])
        if state['isLangevin']:
            self.ui.langevinButton.setChecked(True)
        else:
            self.ui.recValueButton.setChecked(True)
        self.ui.eMob.setText(state['eMob'])
        self.ui.hMob.setText(state['hMob'])
        self.ui.epsRel.setValue(state['eps'])

