from PySide import QtCore, QtGui

class MaterialImage(QtGui.QGraphicsPixmapItem):
    def __init__(self, pixmap, view, parent = None):
        super(MaterialImage, self).__init__(pixmap, parent)
        self.width = pixmap.width()
        self.height = pixmap.height()
        self.view = view

    def mousePressEvent(self, event):
        x = int(event.pos().x())
        y = int(event.pos().y())
        if x >= 0 and x < self.width and y >= 0 and y < self.height:
            self.view.imageClicked(x, y)

class MaterialGraphicsView(QtGui.QGraphicsView):
    imageClickedSignal = QtCore.Signal((int,int))

    def __init__(self, parent):
        super(MaterialGraphicsView, self).__init__(parent)
        
        self.scene = QtGui.QGraphicsScene(parent)
        self.setScene(self.scene)

        self.pixmapItem = None
        self.rectItem = None

        self.setViewportUpdateMode(self.BoundingRectViewportUpdate)
        self.setRenderHint(QtGui.QPainter.Antialiasing)

        self.setMatrix(QtGui.QMatrix(1,0,0,-1,0,0), False)

    def setRegionImage(self, regImage):
        
        if self.pixmapItem:
            self.scene.removeItem(self.pixmapItem)
            self.pixmapItem = None
            self.scene.removeItem(self.rectItem)
            self.rectItem = None

        if regImage:
            w = regImage.getWidth()
            h = regImage.getHeight()
            img = QtGui.QImage(w, h, QtGui.QImage.Format_RGB32)
            for x in range(0, w):
                for y in range(0, h):
                    regIdx = regImage.getRegionIndex(x, y)
                    img.setPixel(x, y, regImage.getRegionColor(regIdx))

            self.pixmapItem = MaterialImage(QtGui.QPixmap.fromImage(img), self)
            self.scene.addItem(self.pixmapItem)
            self.rectItem = self.scene.addRect(0, 0, w, h, QtGui.QPen(QtGui.QColor(0,0,192)), QtGui.QBrush())

        self.setWidthHeight(regImage)
        self.setMatrix(QtGui.QMatrix(1,0,0,-1,0,0), False)

    def setWidthHeight(self, regImage):

        if not self.pixmapItem: # won't have any effect
            return

        try:
            width = float(regImage.getPhysicalWidth())/regImage.getWidth()
            height = float(regImage.getPhysicalHeight())/regImage.getHeight()
        except:
            return

        updateRatio = True
        scaledWidth = 1
        scaledHeight = 1
        if width > height:
            scaledWidth = width/height
            scaledHeight = 1
            if scaledWidth > 100:
                updateRatio = False
        elif width < height:
            scaledWidth = 1
            scaledHeight = height/width
            if scaledHeight > 100:
                updateRatio = False

        if not updateRatio: 
            # TODO: or use scaledWidth = scaledHeight = 1 ?
            return

        t = QtGui.QTransform(scaledWidth, 0, 0, scaledHeight, 0, 0)

        self.pixmapItem.setTransform(t)
        self.rectItem.setTransform(t)

        self.setSceneRect(-1, -1, scaledWidth*(regImage.getWidth()+1), scaledHeight*(regImage.getHeight()+1))

    def wheelEvent(self, event):
        self.scaleView(pow(2.0, -event.delta() / 240.0))

        point = event.pos()
        self.centerOn(self.mapToScene(point));

    def scaleView(self, scaleFactor):
        factor = self.matrix().scale(scaleFactor, scaleFactor).mapRect(QtCore.QRectF(0, 0, 1, 1)).width()
        if factor < 0.00001 or factor > 10000:
	        return

        self.scale(scaleFactor, scaleFactor)

    def imageClicked(self, x, y):
        self.imageClickedSignal.emit(x, y)

