#ifndef SEARCHFUNCTION_H

#define SEARCHFUNCTION_H

#include <string>

class SearchFunction
{
public:
	SearchFunction()						{ }
	virtual ~SearchFunction()					{ }

	virtual int getDimension() const = 0;
	virtual void setFunctionPoint(const double *pPoint) = 0;
	virtual bool evaluate() = 0;
	virtual double getValue() const					{ return m_value; }
	virtual const double *getCurrentPoint() const = 0;
	virtual std::string getPointString() const = 0;

	virtual SearchFunction *createNewInstance() const = 0;
	virtual SearchFunction *createCopy() const = 0;
protected:
	void setValue(double x)						{ m_value = x; }
private:
	double m_value;
};

class SearchFunctionWrapper
{
public:
	SearchFunctionWrapper()						{ m_pSearchFunction = 0; }
	SearchFunctionWrapper(SearchFunction *pSF)			{ m_pSearchFunction = pSF; }
	~SearchFunctionWrapper()					{ }

	SearchFunction *getFunction() const				{ return m_pSearchFunction; }
private:
	SearchFunction *m_pSearchFunction;
};

inline bool operator< (const SearchFunctionWrapper &w1, const SearchFunctionWrapper &w2)
{
	double v1 = w1.getFunction()->getValue();
	double v2 = w2.getFunction()->getValue();

	return (v1 < v2);
}

#endif // SEARCHFUNCTION_H

