#ifndef GSLRANDOMNUMBERGENERATOR_H

#define GSLRANDOMNUMBERGENERATOR_H

#include <mogal/randomnumbergenerator.h>
#include <gsl/gsl_rng.h>
#include <time.h>
#ifndef WIN32
	#include <unistd.h>
#else
	#include <process.h>
	#include <stdlib.h>
#endif // WIN32

class GslRandomNumberGenerator : public mogal::RandomNumberGenerator
{
public:
	GslRandomNumberGenerator()
	{
#ifdef WIN32
		// Added this function myself to work around the unsersolved symbol message
		// should probably work this out in the gsl port :)
		m_pRng = gsl_rng_alloc(gsl_rng_get_default());
#else
		m_pRng = gsl_rng_alloc(gsl_rng_mt19937);
#endif//

		uint32_t x;
	#ifdef WIN32

		x = (uint32_t)_getpid();
		x += (uint32_t)time(0);
		x += (uint32_t)clock();
		x ^= (uint32_t)((uint8_t *)this - (uint8_t *)0);
	#else
		x = (uint32_t)getpid();
		x += (uint32_t)time(0);
		x += (uint32_t)clock();
		x ^= (uint32_t)((uint8_t *)this - (uint8_t *)0);
	#endif
		/*

		uint32_t x;

		x = (uint32_t)getpid();
		x += (uint32_t)time(0);
		x -= (uint32_t)clock();
		x ^= (uint32_t)((uint64_t)(this));
		*/
		// std::cout << "x = " << x << std::endl;
		gsl_rng_set(m_pRng, x);
	}
	
	~GslRandomNumberGenerator()
	{
		gsl_rng_free(m_pRng);
	}

	double pickRandomNumber() const
	{
		return gsl_rng_uniform(m_pRng);
	}
private:
	mutable gsl_rng *m_pRng;
};

#endif // GSLRANDOMNUMBERGENERATOR_H
