#ifndef EXTPROGSEARCHFUNCTION_H

#define EXTPROGSEARCHFUNCTION_H

#include "simiconductorconfig.h"
#include "amoeba.h"
#include <vector>
#include <string>

class ExtProgGenome;
class ExtProgGAFactory;

class ExtProgSearchFunction : public SearchFunction
{
public:
	ExtProgSearchFunction(ExtProgGAFactory *pGAFact);
	ExtProgSearchFunction(ExtProgGenome *pGenome);
	~ExtProgSearchFunction();

	int getDimension() const;
	void setFunctionPoint(const double *pPoint);
	bool evaluate();
	const double *getCurrentPoint() const;
	SearchFunction *createNewInstance() const;
	SearchFunction *createCopy() const;
	std::string getParameterString() const;
	std::string getPointString() const;
private:
	ExtProgGenome *m_pGenome;
	mutable std::vector<double> m_params;
};

#endif // EXTPROGSEARCHFUNCTION_H
