#include "extprogsearchfunction.h"
#include "extproggafactory.h"
#include "extproggenome.h"

ExtProgSearchFunction::ExtProgSearchFunction(ExtProgGAFactory *pGAFact)
{ 
	m_pGenome = (ExtProgGenome *)pGAFact->createNewGenome(); 
}
	
ExtProgSearchFunction::ExtProgSearchFunction(ExtProgGenome *pGenome)
{
	m_pGenome = pGenome; 
}

ExtProgSearchFunction::~ExtProgSearchFunction()
{
	delete m_pGenome;
}

int ExtProgSearchFunction::getDimension() const
{
	return m_pGenome->getNumberOfParameters();
}

void ExtProgSearchFunction::setFunctionPoint(const double *pPoint)
{
	bool equal = false;
	int numParams = m_pGenome->getNumberOfParameters();

	if (m_params.size() != 0)
	{
		equal = true;

		for (int i = 0 ; i < numParams && equal ; i++)
		{
			if (m_params[i] != pPoint[i])
				equal = false;
		}
	}
	else
		m_params.resize(numParams);

	if (!equal)
	{
		ExtProgGAFactory *pFact = (ExtProgGAFactory *)m_pGenome->getFactory();
		ExtProgGAFactoryParams *pFactParams = (ExtProgGAFactoryParams * )pFact->getCurrentParameters();
		std::vector<double> newParams(numParams);

		for (int i = 0 ; i < numParams ; i++)
			m_params[i] = pPoint[i];

		delete m_pGenome;

		m_pGenome = new ExtProgGenome(pFact, numParams, pFact->getNumberOfFitnessComponents());
		m_pGenome->setParameters(&(m_params[0]));
	}
}

bool ExtProgSearchFunction::evaluate()
{
	mogal::DoubleVectorGenome *pGen = m_pGenome;
	if (!pGen->calculateFitness())
		return false;

	setValue(m_pGenome->getFitnessValues()[0]); // Amoeba can only use a single fitness value, we'll use the first one
	return true;
}

const double *ExtProgSearchFunction::getCurrentPoint() const
{
	ExtProgGAFactory *pFact = (ExtProgGAFactory *)m_pGenome->getFactory();
	ExtProgGAFactoryParams *pFactParams = (ExtProgGAFactoryParams * )pFact->getCurrentParameters();
	const double *pParams = m_pGenome->getParameters();
	int numParams = m_pGenome->getNumberOfParameters();

	if (m_params.size() == 0)
		m_params.resize(numParams);

	for (int i = 0 ; i < numParams ; i++)
		m_params[i] = pParams[i];

	return &(m_params[0]);
}

SearchFunction *ExtProgSearchFunction::createNewInstance() const
{
	ExtProgGenome *pGenome = (ExtProgGenome *)m_pGenome->getFactory()->createNewGenome();

	return new ExtProgSearchFunction(pGenome);
}

SearchFunction *ExtProgSearchFunction::createCopy() const
{
	ExtProgGenome *pGenome = (ExtProgGenome *)m_pGenome->clone();

	return new ExtProgSearchFunction(pGenome);
}

std::string ExtProgSearchFunction::getParameterString() const
{
	return m_pGenome->getParameterString();
}

std::string ExtProgSearchFunction::getPointString() const
{
	return m_pGenome->getParameterString();
}

