#ifndef EXTPROGMOGAFACTORY_H

#define EXTPROGMOGAFACTORY_H

#include "simiconductorconfig.h"
#include <mogal/doublevectorgafactory.h>
#include <mogal/doublevectorgafactoryparams.h>
#include <mogal/gafactorymultiobjective.h>
#include <string>

class ExtProgMOGAFactoryParams : public mogal::DoubleVectorGAFactoryParams
{
public:
	ExtProgMOGAFactoryParams();
	ExtProgMOGAFactoryParams(int numParameters, int numFitnessComponents, const std::string &executable);
	~ExtProgMOGAFactoryParams();

	std::string getExecutable() const								{ return m_executable; }
	int getNumberOfFitnessComponents() const							{ return m_numFitnessComponents; }

	bool write(serut::SerializationInterface &si) const;
	bool read(serut::SerializationInterface &si);
private:
	std::string m_executable;
	int m_numFitnessComponents;
};

class ExtProgMOGAFactory : public mogal::DoubleVectorGAFactory, public mogal::GAFactoryMultiObjective
{
public:
	ExtProgMOGAFactory();
	~ExtProgMOGAFactory();
	
	bool subInit(const mogal::DoubleVectorGAFactoryParams *pParams);

	mogal::GAFactoryParams *createParamsInstance() const;
	mogal::Genome *createNewGenome() const;

	const mogal::RandomNumberGenerator *getRandomNumberGenerator() const				{ return m_pRndGen; }

	mogal::Genome *selectPreferredGenome(const std::list<mogal::Genome *> &bestGenomes) const;
private:
	void onGeneticAlgorithmStep(int generation, bool *generationInfoChanged, bool *pStopAlgorithm);
private:
	mogal::RandomNumberGenerator *m_pRndGen;
};

#endif // EXTPROGMOGAFACTORY_H
