#include "extprogmogafactory.h"
#include "extproggenome.h"
#include "gslrandomnumbergenerator.h"

using namespace mogal;

ExtProgMOGAFactoryParams::ExtProgMOGAFactoryParams()
{
}

ExtProgMOGAFactoryParams::ExtProgMOGAFactoryParams(int numParameters, int numFitnessComponents, 
		                                   const std::string &executable) : DoubleVectorGAFactoryParams(numParameters)
{
	m_executable = executable;
	m_numFitnessComponents = numFitnessComponents;
}

ExtProgMOGAFactoryParams::~ExtProgMOGAFactoryParams()
{
}

bool ExtProgMOGAFactoryParams::write(serut::SerializationInterface &si) const
{
	if (!DoubleVectorGAFactoryParams::write(si))
		return false;
	if (!si.writeInt32(m_numFitnessComponents))
	{
		setErrorString("Error writing number of fitness components: " + si.getErrorString());
		return false;
	}
	if (!si.writeString(m_executable))
	{
		setErrorString("Error writing executable name: " + si.getErrorString());
		return false;
	}
	return true;
}

bool ExtProgMOGAFactoryParams::read(serut::SerializationInterface &si)
{
	if (!DoubleVectorGAFactoryParams::read(si))
		return false;

	int32_t x;
	
	if (!si.readInt32(&x))
	{
		setErrorString("Error reading number of fitness components: " + si.getErrorString());
		return false;
	}
	m_numFitnessComponents = x;

	if (!si.readString(m_executable))
	{
		setErrorString("Error reading executable name: " + si.getErrorString());
		return false;
	}
	return true;
}


ExtProgMOGAFactory::ExtProgMOGAFactory()
{
	m_pRndGen = new GslRandomNumberGenerator();
}

ExtProgMOGAFactory::~ExtProgMOGAFactory()
{
	delete m_pRndGen;
}

bool ExtProgMOGAFactory::subInit(const DoubleVectorGAFactoryParams *pParams)
{
	const ExtProgMOGAFactoryParams *pExtParams = (const ExtProgMOGAFactoryParams *)pParams;
	std::string executable = pExtParams->getExecutable();
	int numFitness = pExtParams->getNumberOfFitnessComponents();

	if (executable.length() == 0)
	{
		setErrorString("The executable name has not been set yet");
		return false;
	}
	if (numFitness < 2)
	{
		setErrorString("At least two fitness components are required for a multi-objective algorithm");
		return false;
	}

	setNumberOfFitnessComponents(numFitness); // The MO base factory needs to be informed of this

	return true;
}

GAFactoryParams *ExtProgMOGAFactory::createParamsInstance() const
{
	return new ExtProgMOGAFactoryParams();
}

Genome *ExtProgMOGAFactory::createNewGenome() const
{
	return new ExtProgGenome((ExtProgMOGAFactory *)this, getNumberOfParameters(), getNumberOfFitnessComponents());
}

// Assume that the first fitness value is the most important, then the second, etc
Genome *ExtProgMOGAFactory::selectPreferredGenome(const std::list<Genome *> &bestGenomes) const
{
	std::list<Genome *>::const_iterator it;
	std::list<DoubleVectorGenome *> tmpGenomes[2];
	std::list<DoubleVectorGenome *>::const_iterator it2;

	DoubleVectorGenome *pPreferredGenome = 0;

	for (it = bestGenomes.begin() ; it != bestGenomes.end() ; it++)
		tmpGenomes[0].push_back((DoubleVectorGenome *)(*it));

	int numFitness = getNumberOfFitnessComponents();

	for (int i = 0 ; i < numFitness ; i++)
	{
		int idx = i%2;
		int nextIdx = (i+1)%2;
		
		if (tmpGenomes[idx].empty())
			break;

		tmpGenomes[nextIdx].clear();
		
		double minValue = (*(tmpGenomes[idx].begin()))->getFitnessValues()[i];

		for (it2 = tmpGenomes[idx].begin() ; it2 != tmpGenomes[idx].end() ; it2++)
		{
			double curValue = (*it2)->getFitnessValues()[i];

			if (curValue < minValue)
				minValue = curValue;
		}

		for (it2 = tmpGenomes[idx].begin() ; it2 != tmpGenomes[idx].end() ; it2++)
		{
			double curValue = (*it2)->getFitnessValues()[i];

			if (curValue == minValue)
				tmpGenomes[nextIdx].push_back(*it2);
		}
	}

	int curIdx = numFitness%2;

	if (!tmpGenomes[curIdx].empty()) // If there's more than one with the same fitness values, we'll just pick the first one
		pPreferredGenome = *(tmpGenomes[curIdx].begin());

	return pPreferredGenome;
}

void ExtProgMOGAFactory::onGeneticAlgorithmStep(int generation, bool *generationInfoChanged, bool *pStopAlgorithm)
{
	// TODO: Adjust the stopping criterion
	if (generation >= 200)
		*pStopAlgorithm = true;
}
