#include "extproggenome.h"
#include "extproggafactory.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <iostream>

using namespace mogal;

#ifdef WIN32
#define popen _popen
#define pclose _pclose
#endif // WIN32

ExtProgGenome::ExtProgGenome(DoubleVectorGAFactory *pFactory, int numParams, int numFitness) : DoubleVectorGenome(pFactory, numParams, numFitness)
{
}

ExtProgGenome::~ExtProgGenome()
{
}

bool ExtProgGenome::calculateFitness(const double *pParams, int numParams, double *pFitnessValues, int numFitnessValues)
{
	char str[1024];
	const ExtProgGAFactoryParams *pFactoryParams = (const ExtProgGAFactoryParams *)getFactory()->getCurrentParameters();
	std::string cmdLine;
	
	cmdLine += pFactoryParams->getExecutable();
	cmdLine += std::string(" ");
	cmdLine += getParameterString(pParams, numParams);
	
	FILE *pOutput = popen(cmdLine.c_str(), "r");
	if (pOutput == 0)
	{
		std::cerr << "Can't execute command and stream output: " << strerror(errno) << std::endl;
		std::cerr << "Command was: " << std::endl;
		std::cerr << "  " << cmdLine << std::endl;
		return false;
	}
	
	for (int i = 0 ; i < numFitnessValues ; i++)
	{
		double result = 0;
		int status = 0;

		if ((status = fscanf(pOutput, "%lg", &result)) != 1)
		{
			std::cerr << "Can't read resulting fitness value " << (i+1) << std::endl;
			std::cerr << "status = " << status << std::endl;
			std::cerr << "ferror = " << ferror(pOutput) << std::endl;
			std::cerr << "errno = " << errno << std::endl;
			std::cerr << "strerror = " << strerror(errno) << std::endl;
			std::cerr << "Command was: " << std::endl;
			std::cerr << "  " << cmdLine << std::endl;
			pclose(pOutput);
			return false;
		}

		pFitnessValues[i] = result;
	}

/*	int status;

	if ((status = pclose(pOutput)) != 0)
	{
		std::cerr << "Got non-zero error code from program '" + pFactoryParams->getExecutable() + "': " << status << std::endl;
		std::cerr << "Command was: " << std::endl;
		std::cerr << "  " << cmdLine << std::endl;
		return false;
	}*/
	pclose(pOutput);
	return true;
}

std::string ExtProgGenome::getParameterString() const
{
	return getParameterString(getParameters(), getNumberOfParameters());
}

std::string ExtProgGenome::getParameterString(const double *pParams, int numParams)
{
	char str[1024];
	std::string cmdLine;

	sprintf(str, "%.15g", pParams[0]);
	cmdLine += std::string(str);

	for (int i = 1 ; i < numParams ; i++)
	{
		sprintf(str, " %.15g", pParams[i]);
		cmdLine += std::string(str);
	}

	return cmdLine;
}

