#ifndef EXTPROGGAFACTORY_H

#define EXTPROGGAFACTORY_H

#include "simiconductorconfig.h"
#include <mogal/doublevectorgafactory.h>
#include <mogal/doublevectorgafactoryparams.h>
#include <mogal/gafactorysingleobjective.h>
#include <string>

class ExtProgGAFactoryParams : public mogal::DoubleVectorGAFactoryParams
{
public:
	ExtProgGAFactoryParams();
	ExtProgGAFactoryParams(int numParameters, const std::string &executable);
	~ExtProgGAFactoryParams();

	std::string getExecutable() const								{ return m_executable; }

	bool write(serut::SerializationInterface &si) const;
	bool read(serut::SerializationInterface &si);
private:
	std::string m_executable;
};

class ExtProgGAFactory : public mogal::DoubleVectorGAFactory, public mogal::GAFactorySingleObjective
{
public:
	ExtProgGAFactory();
	~ExtProgGAFactory();
	
	bool subInit(const mogal::DoubleVectorGAFactoryParams *pParams);

	mogal::GAFactoryParams *createParamsInstance() const;
	mogal::Genome *createNewGenome() const;

	const mogal::RandomNumberGenerator *getRandomNumberGenerator() const				{ return m_pRndGen; }
private:
	mogal::RandomNumberGenerator *m_pRndGen;
};

#endif // EXTPROGGAFACTORY_H
