#include "extproggafactory.h"
#include "extproggenome.h"
#include "gslrandomnumbergenerator.h"

using namespace mogal;

ExtProgGAFactoryParams::ExtProgGAFactoryParams()
{
}

ExtProgGAFactoryParams::ExtProgGAFactoryParams(int numParameters, const std::string &executable) : DoubleVectorGAFactoryParams(numParameters)
{
	m_executable = executable;
}

ExtProgGAFactoryParams::~ExtProgGAFactoryParams()
{
}

bool ExtProgGAFactoryParams::write(serut::SerializationInterface &si) const
{
	if (!DoubleVectorGAFactoryParams::write(si))
		return false;
	if (!si.writeString(m_executable))
	{
		setErrorString("Error writing executable name: " + si.getErrorString());
		return false;
	}
	return true;
}

bool ExtProgGAFactoryParams::read(serut::SerializationInterface &si)
{
	if (!DoubleVectorGAFactoryParams::read(si))
		return false;
	if (!si.readString(m_executable))
	{
		setErrorString("Error reading executable name: " + si.getErrorString());
		return false;
	}
	return true;
}


ExtProgGAFactory::ExtProgGAFactory()
{
	m_pRndGen = new GslRandomNumberGenerator();
}

ExtProgGAFactory::~ExtProgGAFactory()
{
	delete m_pRndGen;
}

bool ExtProgGAFactory::subInit(const DoubleVectorGAFactoryParams *pParams)
{
	const ExtProgGAFactoryParams *pExtParams = (const ExtProgGAFactoryParams *)pParams;
	std::string executable = pExtParams->getExecutable();

	if (executable.length() == 0)
	{
		setErrorString("The executable name has not been set yet");
		return false;
	}

	return true;
}

GAFactoryParams *ExtProgGAFactory::createParamsInstance() const
{
	return new ExtProgGAFactoryParams();
}

Genome *ExtProgGAFactory::createNewGenome() const
{
	return new ExtProgGenome((ExtProgGAFactory *)this, getNumberOfParameters(), getNumberOfFitnessComponents());
}

