#ifndef AMOEBA_H

#define AMOEBA_H
 
#include "searchfunction.h"
#include <errut/errorbase.h>
#include <vector>

class Amoeba : public errut::ErrorBase
{
public:
	Amoeba();
	~Amoeba();

	bool init(std::vector<SearchFunction *> initialPoints, double alpha = 1.0, 
	          double gamma = 2.0, double rho = 0.5, double sigma = 0.5);
	void clear();

	bool step(double &bestValue);
	const SearchFunction *getBestPoint() const						{ return m_pBestPoint; }
private:
	std::vector<SearchFunctionWrapper> m_currentPoints;
	SearchFunction *m_pBestPoint;

	double m_alpha, m_gamma, m_rho, m_sigma;
	int m_dimension;
	
};

#endif // AMOEBA_H
